package com.example.bytesbee.alphabets.activities.easyads;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.Display;
import android.widget.LinearLayout;

import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.RequestConfiguration;

import java.util.Collections;
import java.util.List;

/**
 * Created by BytesBee.
 *
 * @author BytesBee
 * @link http://bytesbee.com
 */
public class EasyAdsDynamic {
    private static final Handler delayHandler = new Handler();

    public static void MainAppId(Context context) {
        MobileAds.initialize(context, initializationStatus -> {
        });
//        testDevice();
    }

    public static void testDevice() {
        List<String> testDeviceIds = Collections.singletonList("52A3155CBE8F5DE8144E7AB514A9BFA9");
        RequestConfiguration configuration = new RequestConfiguration.Builder().setTestDeviceIds(testDeviceIds).build();
        MobileAds.setRequestConfiguration(configuration);
    }

    public static Banner forBanner(Context context) {
        return new Banner(context);
    }

    public static class Banner {

        final Context context;
        LinearLayout adLayout = null;
        AdView adViewBanner;
        final AdRequest.Builder adRequestBuilder;

        private Banner(final Context context) {
            this.context = context;
            adRequestBuilder = new AdRequest.Builder();
        }

        public Banner withLayout(LinearLayout adLayoutBanner, AdView adViewBanner) {
            this.adLayout = adLayoutBanner;
            this.adViewBanner = adViewBanner;
            return this;
        }

        public Banner with(AdView adViewBanner) {
            this.adViewBanner = adViewBanner;
            return this;
        }

        public Banner adUnitId(String adsUnitId) {
            this.adViewBanner.setAdUnitId(adsUnitId);
            return this;
        }

        public Banner adSize(AdSize adSize) {
            this.adViewBanner.setAdSize(adSize);
            return this;
        }

        public Banner listener(AdListener adListener) {
            adViewBanner.setAdListener(adListener);
            return this;
        }

        public void show() {
            this.adViewBanner.setAdSize(getAdSize(((Activity) context)));

            Runnable delayRunnable = () -> {
                try {
                    adLayout.addView(adViewBanner);
                } catch (Exception ignored) {
                }
                try {
                    adViewBanner.loadAd(adRequestBuilder.build());
                } catch (Exception ignored) {
                }
            };
            long delayTime = 0;
            delayHandler.postDelayed(delayRunnable, delayTime);
        }

        private AdSize getAdSize(final Activity mActivity) {
            // Step 2 - Determine the screen width (less decorations) to use for the ad width.
            Display display = mActivity.getWindow().getWindowManager().getDefaultDisplay();
            DisplayMetrics outMetrics = new DisplayMetrics();
            display.getMetrics(outMetrics);

            float widthPixels = outMetrics.widthPixels;
            float density = outMetrics.density;

            int adWidth = (int) (widthPixels / density);

            // Step 3 - Get adaptive ad size and return for setting on the ad view.
            return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize(mActivity, adWidth);
        }
    }

}